implementation module StdProcess

//	Clean Standard Object I/O library, version 1.1

import	StdInt, StdBool, StdList, StdFunc
// RWS --- from	quickdraw		import QScreenRect
import	StdProcessDef, /* RWS --- StdWindow, */ StdPSt, iostate
from StdWindow import openWindow
/* RWS ---
from	timerdevice		import TimerFunctions
from	windowdevice	import WindowFunctions
from	menudevice		import MenuFunctions
from	receiverdevice	import ReceiverFunctions
*/
import	processdefaccess, scheduler // RWS ---, deviceaccess, menuwindowmenu

// RWS +++
import commondef, oswindow

//	General process topology creation functions:

class Processes pdef
where
	startProcesses :: !pdef !*World      -> *World
	openProcesses  :: !pdef !(PSt .l .p) -> PSt .l .p

instance Processes (ProcessGroup pdef)	| shareProcesses pdef
where
	startProcesses :: !(ProcessGroup pdef) !*World -> *World	| shareProcesses pdef
	startProcesses (ProcessGroup public pDef) world
		# (initContext, tb)	= initContext [shareProcesses pDef] "" (0,public) NDI VirtualProcess world
		# (finalContext,tb)	= handleEvents initContext tb
		= closeContext finalContext tb
	
	openProcesses :: !(ProcessGroup pdef) !(PSt .l .p) -> PSt .l .p	| shareProcesses pdef
	openProcesses (ProcessGroup public pDef) pState
		= addVirtualProcess [shareProcesses pDef] "" (0,public) pState

instance Processes [pdef]	| Processes pdef
where
	startProcesses :: ![pdef] !*World -> *World	| Processes pdef
	startProcesses pDefs world
		# (initContext, tb)	= initContext (revmap openProcesses pDefs) "" (0,0) NDI VirtualProcess world
		# (finalContext,tb)	= handleEvents initContext tb
		= closeContext finalContext tb
	
	openProcesses :: ![pdef] !(PSt .l .p) -> PSt .l .p	| Processes pdef
	openProcesses pDefs pState
		= addVirtualProcess (revmap openProcesses pDefs) "" (0,0) pState

instance Processes (:^: pdef1 pdef2)	| Processes pdef1 & Processes pdef2
where
	startProcesses :: !(:^: pdef1 pdef2) !*World -> *World	| Processes pdef1 & Processes pdef2
	startProcesses (pdef1:^:pdef2) world
		# (initContext, tb)	= initContext [openProcesses pdef1,openProcesses pdef2] "" (0,0) NDI VirtualProcess world
		# (finalContext,tb)	= handleEvents initContext tb
		= closeContext finalContext tb
	
	openProcesses :: !(:^: pdef1 pdef2) !(PSt .l .p) -> PSt .l .p	| Processes pdef1 & Processes pdef2
	openProcesses (pdef1:^:pdef2) pState
		= addVirtualProcess [openProcesses pdef1,openProcesses pdef2] "" (0,0) pState


class shareProcesses pdef :: !(pdef .p) !(PSt .l .p) -> PSt .l .p

instance shareProcesses NDIProcess
where
	shareProcesses :: !(NDIProcess .p) !(PSt .l .p) -> PSt .l .p
	shareProcesses (NDIProcess local init atts) pState
		= addInteractiveProcess atts init "" local (Contains isprocessshareGUI atts) NDI pState

instance shareProcesses	(SDIProcess wdef)	| Windows wdef
where
	shareProcesses :: !(SDIProcess wdef .p) !(PSt .l .p) -> PSt .l .p	| Windows wdef
	shareProcesses (SDIProcess local wLocal wDef init atts) pState
		= addInteractiveProcess atts [open wLocal wDef:init] "" local (Contains isprocessshareGUI atts) SDI pState
	where
		open :: .ls !(wdef .ls (PSt .l .p)) !(PSt .l .p) -> PSt .l .p	| Windows wdef
		open ls wDef pState
			# (error,pState)	= openWindow ls wDef pState
			| error==NoError
			= pState
			= FatalError "shareProcesses" "StdProcess" "could not create initial window for SDIProcess"

instance shareProcesses MDIProcess
where
	shareProcesses :: !(MDIProcess .p) !(PSt .l .p) -> PSt .l .p
	shareProcesses (MDIProcess local init atts) pState
		= addInteractiveProcess atts init1 "" local shareGUI MDI pState
	where
		shareGUI	= Contains isprocessshareGUI atts
/* RWS ...
		init1		= if (Contains isprocessnowindowmenu atts || shareGUI) init [openWindowMenu:init]
*/
		init1		= init
/* ... RWS */

instance shareProcesses	(ListCS pdef)	| shareProcesses pdef
where
	shareProcesses :: !(ListCS pdef .p) !(PSt .l .p) -> PSt .l .p	| shareProcesses pdef
	shareProcesses (ListCS [pDef:pDefs]) pState
		= shareProcesses pDef (shareProcesses (ListCS pDefs) pState)
	shareProcesses _ pState
		= pState

instance shareProcesses	(:~: pdef1 pdef2)	| shareProcesses pdef1 & shareProcesses pdef2
where
	shareProcesses :: !(:~: pdef1 pdef2 .p) !(PSt .l .p) -> PSt .l .p	| shareProcesses pdef1 & shareProcesses pdef2
	shareProcesses (pDef1:~:pDef2) pState
		= shareProcesses pDef1 (shareProcesses pDef2 pState)

revmap :: !(.x -> .y) ![.x] -> [.y]
revmap f xs
	= revmap_ f xs []
where
	revmap_ :: !(.x -> .y) ![.x] ![.y] -> [.y]
	revmap_ f [x:xs] ys = revmap_ f xs [f x:ys]
	revmap_ _ _ ys		= ys


//	Specialised process creation functions:

startIO :: !.l !.p !(ProcessInit (PSt .l .p)) ![ProcessAttribute (PSt .l .p)] !*World -> *World
startIO local public init atts world
	= startProcesses (ProcessGroup public (MDIProcess local init [ProcessNoWindowMenu:atts])) world


//	Close this interactive process.

closeProcess :: !(PSt .l .p) -> PSt .l .p
closeProcess pState=:{io}
	= {pState & io=quitProcess io}


//	Hide or show this interactive process.

ShouldHide :== True
ShouldShow :== False

hideProcess :: !(IOSt .l .p) -> IOSt .l .p
hideProcess ioState
	= hide_show ShouldHide ioState

showProcess :: !(IOSt .l .p) -> IOSt .l .p
showProcess ioState
	= hide_show ShouldShow ioState

hide_show :: !Bool !(IOSt .l .p) -> IOSt .l .p
hide_show shouldHide ioState
	# (nr,ioState)		= IOStGetIOId ioState
	# (ioStack,ioState)	= IOStGetProcessStack ioState
	# ioStack			= setProcessShowState nr (not shouldHide) ioStack
	# ioState			= IOStSetProcessStack ioStack ioState
	# ioState			= StateMap2 hideOrShow Devices ioState
	= ioState
where
	hideOrShow			= if shouldHide DeviceHideFunction DeviceShowFunction


//	Access rules to the DeviceFunctions:

DeviceShowFunction :: !Device -> ShowFunction .l .p
DeviceShowFunction device
	= (getDeviceFunctions device).dShow

DeviceHideFunction :: !Device -> HideFunction .l .p
DeviceHideFunction device
	= (getDeviceFunctions device).dHide

/* RWS ---
getDeviceFunctions :: !Device -> DeviceFunctions i o .l .p
getDeviceFunctions TimerDevice		= TimerFunctions
getDeviceFunctions MenuDevice 		= MenuFunctions
getDeviceFunctions WindowDevice		= WindowFunctions
getDeviceFunctions ReceiverDevice	= ReceiverFunctions
*/

/* RWS ..
//	Get the current position of the ProcessWindow (on Macintosh: zero)

getProcessWindowPos :: !(IOSt .l .p) -> (!Point,!IOSt .l .p)
getProcessWindowPos ioState
	= (zero,ioState)


//	Get the current size of the ProcessWindow (on Macintosh: ScreenSize)

getProcessWindowSize :: !(IOSt .l .p) -> (!Size,!IOSt .l .p)
getProcessWindowSize ioState
	# (tb,ioState)		= getIOToolbox ioState
	# (_,_,sR,sB,tb)	= QScreenRect tb
	# ioState			= setIOToolbox tb ioState
	= ({w=sR,h=sB-TitleBarWidth},ioState)
*/
//	Get the current position of the ProcessWindow (on Macintosh: zero)

getProcessWindowPos :: !(IOSt .l .p) -> (!Point,!IOSt .l .p)
getProcessWindowPos ioState
	# (tb,ioState)		= getIOToolbox ioState
	# ((x,y,_,_),tb)	= OSGetProcessWindowDimensions tb
	# ioState			= setIOToolbox tb ioState
	= ({x=x,y=y},ioState)

//	Get the current size of the ProcessWindow (on Macintosh: ScreenSize)

getProcessWindowSize :: !(IOSt .l .p) -> (!Size,!IOSt .l .p)
getProcessWindowSize ioState
	# (tb,ioState)		= getIOToolbox ioState
	# ((_,_,w,h),tb)	= OSGetProcessWindowDimensions tb
	# ioState			= setIOToolbox tb ioState
	= ({w=w,h=h},ioState)
/* ... RWS */
